#include<can.h>
#include<p30fxxxx.h>

#if defined(__dsPIC30F4013__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__)  || defined(__dsPIC30F6012__) \
    || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4012__) \
    || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)

/*************************************************************************
* Function Name     : CAN1ReceiveMessage
* Description       : This function reads the data from the receive buffer 
*                     into an array.
* Parameters        : unsigned char*: data pointer
*                     unsigned char:  datalen 
*                     char:           MsgFlag
* Return Value      : void
**************************************************************************/

void CAN1ReceiveMessage(unsigned char * data, unsigned char  datalen, 
                        char MsgFlag)
{
    int i;
    for(i = 0;i<datalen;i++)
    {
        switch(MsgFlag)
        {
        case 0:
            data[i]  = *((unsigned char *)&C1RX0B1 + i);
            break;
        case 1: 
            data[i]  = *((unsigned char *)&C1RX1B1 + i);
            break;
        default: 
            data[i]  = *((unsigned char *)&C1RX0B1 + i);
            break;
        }
    }
}

#endif
